package UltimaDemo;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import net.miginfocom.swing.MigLayout;
import SDK.SDKlib;
import SDK.SDKlib.ConnectionType;
import SDK.SDKlib.UltimaInfo;
import SDK.SDKlib.Model;
import SDK.SDKlib.PrinterType;
import SDK.SDKlib.Return;
import SDK.SDKlib.SDKVersion;
import SDK.SDKlib.Status;
import SDK.SDKlib.Temperature;

import com.sun.jna.platform.win32.WinNT.HANDLE;
import com.sun.jna.ptr.ByteByReference;

import static UltimaDemo.Utils.*;
import static UltimaDemo.Main.tabbedPane;

//====================================================================================

class Info {
	private final String SDKBITS = "SDKBITS";
	private final String LASTMSG = "LASTMSG";
	private final String STATUS = "STATUS";
	private final String INFO = "INFO";
	private final String VERSION = "VERSION";
	private final String CONNECTION = "CONNECTION";
	private final String TYPE = "TYPE";
	private final String MODEL = "MODEL";
	private final String TEMPERATURE = "TEMPERATURE";
	private final String CLEAR = "CLEAR";

	private final ActionHandler ah = new ActionHandler();

	public static final JPanel panelInfo = new JPanel();

	private final JButton btnLastMessage = new JButton("Last Message");
	private final JButton btnPrinterStatus = new JButton("Printer Status");
	private final JButton btnPrinterInfo = new JButton("Printer Info");
	private final JButton btnSDKVersion = new JButton("SDK Version");
	private final JButton btnConnectionType = new JButton("Connection Type");
	private final JButton btnPrinterType = new JButton("Printer Type");
	private final JButton btnPrinterModel = new JButton("Printer Model");
	private final JButton btnSDKBits = new JButton("SDK Bits");
	private final JButton btnTemperature = new JButton("Temperature");
	private final JButton btnClear = new JButton("Clear");

	private final JTextArea textInfoMsg = new JTextArea();
	private final JScrollPane scrollPane = new JScrollPane();

	private HANDLE hSession;
	private SDKlib SDK;

	// ====================================================================================

	public Info() {

		panelInfo.setLayout(new MigLayout("", "[190.00][grow]", "[][][][][][][][][][][397.00][]"));

		panelInfo.add(btnSDKVersion, "cell 0 1,growx");
		btnSDKVersion.setActionCommand(VERSION);
		btnSDKVersion.addActionListener(ah);

		panelInfo.add(btnSDKBits, "cell 0 2,growx");
		btnSDKBits.setActionCommand(SDKBITS);
		btnSDKBits.addActionListener(ah);

		panelInfo.add(btnConnectionType, "cell 0 3,growx");
		btnConnectionType.setActionCommand(CONNECTION);
		btnConnectionType.addActionListener(ah);

		panelInfo.add(btnPrinterType, "cell 0 4,growx");
		btnPrinterType.setActionCommand(TYPE);
		btnPrinterType.addActionListener(ah);

		panelInfo.add(btnPrinterModel, "cell 0 5,growx");
		btnPrinterModel.setActionCommand(MODEL);
		btnPrinterModel.addActionListener(ah);

		panelInfo.add(btnPrinterStatus, "cell 0 6,growx");
		btnPrinterStatus.setActionCommand(STATUS);
		btnPrinterStatus.addActionListener(ah);

		panelInfo.add(btnPrinterInfo, "cell 0 7,growx");
		btnPrinterInfo.setActionCommand(INFO);
		btnPrinterInfo.addActionListener(ah);

		panelInfo.add(btnLastMessage, "cell 0 8,growx");
		btnLastMessage.setActionCommand(LASTMSG);
		btnLastMessage.addActionListener(ah);

		panelInfo.add(btnTemperature, "cell 0 9,growx");
		btnTemperature.setActionCommand(TEMPERATURE);
		btnTemperature.addActionListener(ah);

		panelInfo.add(btnClear, "cell 1 11,alignx center");
		btnClear.setActionCommand(CLEAR);
		btnClear.addActionListener(ah);

		panelInfo.add(scrollPane, "cell 1 1 1 10,grow");
		textInfoMsg.setEditable(false);
		scrollPane.setViewportView(textInfoMsg);
	}

	// ====================================================================================

	void Init(HANDLE handle, SDKlib sdk) {
		tabbedPane.addTab("Information", null, panelInfo, null);

		this.hSession = handle;
		this.SDK = sdk;
	}

	// ------------------------------------------------------------------------------------

	void ClearMsg() {
		textInfoMsg.setText(null);
	}

	// ====================================================================================

	private void SDKBits() {
		textInfoMsg.append(SDK.ID_SDKBits() + " Bit SDK\n\n");
	}

	// ------------------------------------------------------------------------------------

	private void LastMsg() {
		StringBuilder Message = new StringBuilder();
		byte sdkReturn = SDK.ID_LastMessage(hSession, Message);
		if (sdkReturn != Return.SUCCESS) {
			DisplayError("GetLastMessage", sdkReturn);
		} 
		else {
			textInfoMsg.append(Message.toString() + "\n\n");
		}
	}

	// ------------------------------------------------------------------------------------

	private void PrinterStatus() {
		String temp_string = "";
		switch (SDK.ID_PrinterStatus(hSession)) {
		case Status.READY:   temp_string = "READY";   break;
		case Status.OFFLINE: temp_string = "OFFLINE"; break;
		case Status.ERROR:   temp_string = "ERROR";   break;
		case Status.BUSY:    temp_string = "BUSY";    break;
		}

		textInfoMsg.append("Printer is " + temp_string + "\n\n");
	}

	// ------------------------------------------------------------------------------------

	private void PrinterInfo() {
		CursorWait();

		UltimaInfo HI = new UltimaInfo();
		byte sdkReturn = SDK.ID_PrinterInfo(hSession, HI);
		if (sdkReturn != Return.SUCCESS) {
			DisplayError("GetPrinterInfo", sdkReturn);
		} 
		else {
			textInfoMsg.append("FirmwareVersion: " + new String(HI.firmwareVersion));
			textInfoMsg.append("\nPrinterSerial: " + new String(HI.printerSerial));
			textInfoMsg.append("\nModelName: " + new String(HI.modelName));
			textInfoMsg.append("\nPrinterPartnerCode: " + HI.printerPartnerCode);
			textInfoMsg.append("\nCapabilityFlags: " + HI.capabilityFlags);
			textInfoMsg.append("\nManufacturer: " + new String(HI.manufacturer));
			textInfoMsg.append("\nTransferTargetTemp: " + HI.transferTargetTemperature);
			textInfoMsg.append("\nTransferActualTemp: " + HI.transferActualTemperature);
			textInfoMsg.append("\nTotalCards: " + HI.totalCards);
			textInfoMsg.append("\nTotalPanels: " + HI.totalPanels);
			textInfoMsg.append("\nCardsOnPrinthead: " + HI.cardsOnPrinthead);
			textInfoMsg.append("\nPanelsOnPrinthead: " + HI.panelsOnPrinthead);
			textInfoMsg.append("\nCardsLowLevel: " + HI.cardsLow);
			textInfoMsg.append("\nColourName: " + new String(HI.colourName));
			textInfoMsg.append("\nColourTotalPrints: " + HI.colourTotalPrints);
			textInfoMsg.append("\nColourPrintsRemaining: " + HI.colourPrintsRemaining);
			textInfoMsg.append("\nColourPartnerCode: " + HI.colourPartnerCode);
			textInfoMsg.append("\nTransferName: " + new String(HI.transferName));
			textInfoMsg.append("\nTransferTotalPrints: " + HI.transferTotalPrints);
			textInfoMsg.append("\nTransferPrintsRemaining: " + HI.transferPrintsRemaining);
			textInfoMsg.append("\nTransferPartnerCode: " + HI.transferPartnerCode);
			textInfoMsg.append("\nErrorCode: " + HI.errorCode);
			textInfoMsg.append("\nErrorContext: " + HI.errorContext);
			textInfoMsg.append("\nCardsBetweenPrompts: " + HI.cardsBetweenPrompts);
			textInfoMsg.append("\nCleaningOverdue: " + HI.cleaningOverdue);
			textInfoMsg.append("\nCardsSinceClean: " + HI.cardsSinceClean);
			textInfoMsg.append("\nPanelsSinceClean: " + HI.panelsSinceClean);
			textInfoMsg.append("\nCleaningCycles: " + HI.cleaningCycles);
			textInfoMsg.append("\nLaminateActualTemperature: " + HI.laminateActualTemperature);
			textInfoMsg.append("\nLaminateTargetTemperature: " + HI.laminateTargetTemperature);
			textInfoMsg.append("\nLaminateType: " + HI.laminateType);
			textInfoMsg.append("\nCardSpeed: " + HI.cardSpeed);
			textInfoMsg.append("\n\n");
		}

		CursorDefault();
	}

	// ------------------------------------------------------------------------------------

	private void SDKVersion() {
		SDKVersion version = new SDKVersion();
		byte sdkReturn = SDK.ID_SDKVersion(hSession, version);
		if (sdkReturn != Return.SUCCESS) {
			DisplayError("GetVersion", sdkReturn);
		} 
		else {
			textInfoMsg.append("Version: " + version.major + "." 
			                               + version.minor + "." 
			                               + version.build + "."
                                           + version.beta + "\n\n");
		}
	}

	// ------------------------------------------------------------------------------------

	private void Connection() {
		String msg;
		switch (SDK.ID_ConnectionType(hSession)) {
		case ConnectionType.USB:      msg = "USB";      break;
		case ConnectionType.ETHERNET: msg = "ETHERNET"; break;
		case ConnectionType.FILE:     msg = "FILE";     break;
		default:                      msg = "UNKNOWN";  break;
		}
		textInfoMsg.append("Connection: " + msg + "\n\n");
	}

	// ------------------------------------------------------------------------------------

	private void Type() {
		textInfoMsg.append("Printer Type - ");
		switch (SDK.ID_PrinterType(hSession)) 
		{
		case PrinterType.RIO:         textInfoMsg.append("RioTango\n\n");            break;
		case PrinterType.AOTA:        textInfoMsg.append("AOTA\n\n");                break;
		case PrinterType.ENDURO:      textInfoMsg.append("Enduro Family\n\n");       break;
		case PrinterType.ULTIMA:      textInfoMsg.append("Ultima\n\n");              break;
		case PrinterType.GENERATION2: textInfoMsg.append("Generation 2 Family\n\n"); break;
		default:                      textInfoMsg.append("UNKNOWN\n\n");             break;
		}
	}

	// ------------------------------------------------------------------------------------

	private void Model() {
		String msg;
		int model = SDK.ID_PrinterModel(hSession);
		if ((model & Model.ULTIMA) != 0) msg = "Ultima";
		else 			                 msg = "UNKNOWN";
		textInfoMsg.append("Printer - " + msg + "\n");

		textInfoMsg.append("Capability:\n");
		if ((model & Model.MAGNETIC) != 0)    textInfoMsg.append("  - Mag Stripe\n");
		if ((model & Model.DUPLEX) != 0)      textInfoMsg.append("  - Duplex\n");
		if ((model & Model.CHIP) != 0)        textInfoMsg.append("  - Chip Encoding\n");
		if ((model & Model.CONTACTLESS) != 0) textInfoMsg.append("  - Contactless Encoding\n");
		if ((model & Model.ETHERNET) != 0)    textInfoMsg.append("  - Ethernet\n");
		if ((model & Model.LAMINATE) != 0)    textInfoMsg.append("  - Laminator\n");
		textInfoMsg.append("\n");
	}

	// ------------------------------------------------------------------------------------

	private void Temperature() {
		ByteByReference Status = new ByteByReference();
		byte sdkReturn = SDK.ID_Temperature(hSession, Temperature.TRANSFER, Status);
		if (sdkReturn != Return.SUCCESS) {
			DisplayError("Temperature", sdkReturn);
		} 
		else {
			textInfoMsg.append("Transfer Temperature: " 
			                   + (Status.getValue() != 0 ? "Ready" : "Preheat") 
			                   + "\n\n");
		}
	}

	// ====================================================================================

	class ActionHandler implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			switch (e.getActionCommand()) {
			case CLEAR:       ClearMsg();      break;
			case LASTMSG:     LastMsg();       break;
			case SDKBITS:     SDKBits();       break;
			case STATUS:      PrinterStatus(); break;
			case INFO:        PrinterInfo();   break;
			case VERSION:     SDKVersion();    break;
			case CONNECTION:  Connection();    break;
			case TYPE:        Type();          break;
			case MODEL:       Model();         break;
			case TEMPERATURE: Temperature();   break;
			}
		}
	}
}
